/***************************************************************************
**
**  This file is part of gpmt.
**
**  gpmt is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpmt is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-17
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

//#include <C1DMTSynthData.h>
//#include <QGpCoreWave.h>

#include "MagnetoTelluricReader.h"
#include "gpmtVersion.h"
#include "gpmtInstallPath.h"

PACKAGE_INFO("gpmt", GPMT)

ApplicationHelp * help();

int main(int argc, char ** argv)
{
  CoreApplication a(argc, argv, help);

  // Options
  MagnetoTelluricReader reader;
  if(reader.setOptions(argc, argv) && reader.read(argc, argv) ) {
    return 0;
  } else {
    return 2;
  }
  // Code used only for initial testing and comparison with Max code
#if 0
  CoreApplication a(argc, argv, help);

  // Options
  //<your option variable>
  // Check arguments
  int i, j=1;
  for(i=1; i<argc; i++) {
    QByteArray arg=argv[i];
    if(arg[0]=='-') {
      if(arg=="<long option>" || arg=="<short option>") {
        CoreApplication::checkOptionArg(i, argc, argv);
        //<your option variable>=argv[i];
      } else {
        App::log(tr("gpmt: bad option %1, see -help\n").arg(argv[i]) );
        return 2;
      }
    } else {
      argv[j++]=argv[i];
    }
  }
  if(j < argc) {
    argv[j]=nullptr;
    argc=j;
  }

  gplib::C1DMTSynthData m;
  std::vector<double> r, h, f;
  r.push_back(100);
  r.push_back(10);
  r.push_back(200);
  m.SetResistivities(r);
  h.push_back(0.020);
  h.push_back(0.010);
  h.push_back(0.0);
  m.SetThicknesses(h);
  double f0=1000.0;
  double af=pow(0.01,1.0/16.0);
  for(int i=0; i<16; i++) {
    f.push_back(f0);
    f0/=af;
    //App::log(1/f0 << Qt::endl;
  }
  m.SetFrequencies(f);
  m.GetData();
  m.WriteAsMtt("toto");
  for(int i=0; i<16; i++) {
    App::log(m.GetFrequencies().at(i) << " " <<
                     m.at(i).GetRhoxy() << " " <<
                     m.at(i).GetPhixy() << Qt::endl;
  }
  MagnetoTelluricCurve c;
  c.resize(16);
  f0=1000.0;
  for(int i=0; i<16; i++) {
    c[i].setX(f0);
    f0/=af;
  }
  MagnetoTelluricFactory fac;
  fac.setX(c);
  fac.linkX(c);
  fac.setAngularFrequency();
  Profile resistivies;
  resistivies.resize(3);
  resistivies.setDepth(0, 20);
  resistivies.setDepth(1, 30);
  resistivies.setDepth(2, std::numeric_limits<double>::infinity());
  resistivies.setValue(0, 100);
  resistivies.setValue(1, 10);
  resistivies.setValue(2, 200);
  fac.calculate(resistivies);
  MagnetoTelluricPointOptions co(MagnetoTelluricPointOptions::ApparentResistivity);
  QTextStream sout(stdout);
  fac.toStream(sout, co);
#endif
}

ApplicationHelp * help()
{
  TRACE;
  ApplicationHelp * h=new ApplicationHelp;
  h->setOptionSummary( "[OPTIONS]" );
  h->setComments( "Compute magneto-telluric impedance curves for 1D layered models given through stdin or FILES.\n\n"
                  "Format for layered models:\n"
                  + Resistivity1DModel::formatHelp() +
                  "\n\n"
                  "Any number of models can be given as input." );
  h->addGroup("gpmt", "gpmt");
  h->addOption("-n <count>","Number of frequency samples (default=10)");
  h->addOption("-s <sampling>","Defines the sampling type:\n"
                              "  period     regular sampling in period\n"
                              "  frequency  regular sampling in frequency\n"
                              "  log        regular sampling in log(frequency) (default)");
  h->addOption("-min <min>","Minimum of range for curve (default=1kHz)");
  h->addOption("-max <max>","Maximum of range for curve (default=100kHz)");
  h->addOption("-apparent-resistivity","Ouput apparent resistivity in ohm m (default)");
  h->addOption("-phase","Ouput phase in degrees");
  h->addOption("-phase-degrees","Ouput phase in degrees");
  h->addOption("-phase-radians","Ouput phase in readians");
  h->addOption("-abs","Ouput absolute value of impedance (V/m/T)");
  h->addOption("-real","Ouput real part of impedance (V/m/T)");
  h->addOption("-imaginary","Ouput imaginary part of impedance (V/m/T)");
  return h;
}
