/***************************************************************************
**
**  This file is part of gpmt.
**
**  gpmt is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpmt is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-27
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "MagnetoTelluricReader.h"

/*!
  \class MagnetoTelluricReader MagnetoTelluricReader.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
MagnetoTelluricReader::MagnetoTelluricReader()
    : ArgumentStdinReader()
{
  _samplingType=LogScale;
  _nSamples=10;
  _minRange=1000;
  _maxRange=100000;
  _outputMode=MagnetoTelluricPointOptions::ApparentResistivity;
}

bool MagnetoTelluricReader::setOptions(int& argc, char ** argv)
{
  TRACE;
  // Check arguments
  int i, j=1;
  for(i=1; i<argc; i++) {
    QByteArray arg=argv[i];
    if(arg[0]=='-') {
      if(arg=="-s") {
        CoreApplication::checkOptionArg(i, argc, argv);
        if(strcmp(argv[i],"period")==0) {
          _samplingType=InverseScale;
        } else if(strcmp(argv[i],"frequency")==0) {
          _samplingType=LinearScale;
        } else {
          _samplingType=LogScale;
        }
      } else if(arg=="-min") {
        CoreApplication::checkOptionArg(i, argc, argv);
        _minRange=CoreApplication::toDouble(i, i-1, argv);
        if(_minRange<=0) {
          App::log(tr("gpmt: negative or null value for -min\n") );
          return false;
        }
      } else if(arg=="-max") {
        CoreApplication::checkOptionArg(i, argc, argv);
        _maxRange=CoreApplication::toDouble(i, i-1, argv);
        if(_maxRange<=0) {
          App::log(tr("gpmt: negative or null value for -max\n") );
          return false;
        }
      } else if(arg=="-n") {
        CoreApplication::checkOptionArg(i, argc, argv);
        _nSamples=CoreApplication::toInt(i, i-1, argv);
        if(_nSamples<=0) {
          App::log(tr("gpmt: negative or null number of samples (option -n)\n") );
          return false;
        }
      } else if(arg=="-apparent-resistivity") {
        _outputMode=MagnetoTelluricPointOptions::ApparentResistivity;
      } else if(arg=="-phase" || arg=="-phase-degrees") {
        _outputMode=MagnetoTelluricPointOptions::PhaseDegrees;
      } else if(arg=="-phase-radians") {
        _outputMode=MagnetoTelluricPointOptions::PhaseDegrees;
      } else if(arg=="-abs") {
        _outputMode=MagnetoTelluricPointOptions::AbsoluteValue;
      } else if(arg=="-real") {
        _outputMode=MagnetoTelluricPointOptions::Real;
      } else if(arg=="-imaginary") {
        _outputMode=MagnetoTelluricPointOptions::Imaginary;
      } else {
        App::log(tr("gpmt: bad option %1, see -help\n").arg(argv[i]) );
        return false;
      }
    } else {
      argv[j++]=argv[i];
    }
  }
  if(j < argc) {
    argv[j]=nullptr;
    argc=j;
  }
  return true;
}

bool MagnetoTelluricReader::parse(QTextStream& s)
{
  TRACE;
  Resistivity1DModel m;
  QString comments;
  if(!m.fromStream(s, &comments)) {
    return false;
  }
  if(m.layerCount()>0) {
    Curve<Point1D> c;
    c.line(_minRange, _maxRange);
    c.resample(_nSamples, _minRange, _maxRange, _samplingType);
    MagnetoTelluricFactory fac;
    fac.setX(c.xVector());
    fac.setAngularFrequency();
    fac.calculate(m);
    MagnetoTelluricPointOptions co(_outputMode);
    QTextStream sout(stdout);
    fac.toStream(sout, co);
  }
  return true;
}
