/***************************************************************************
**
**  This file is part of gplivemodel.
**
**  gplivemodel is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gplivemodel is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-10-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "ControlPanel.h"
#include "ModelSlider.h"

/*!
  \class ControlPanel ControlPanel.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const QString ControlPanel::xmlControlPanelTag="ControlPanel";

/*!
  Description of constructor still missing
*/
ControlPanel::ControlPanel(QWidget * parent)
    : QWidget(parent)
{
  TRACE;
  _referenceModel=0;
  setupUi(this);

  QWidget * w=new QWidget(this);
  QVBoxLayout * layout=new QVBoxLayout(w);
  layout->setContentsMargins (0, 0, 0, 0);
  layout->setSpacing (0);
  layout->addStretch();
  sliderList->setWidget(w);

  on_addSliderBut_clicked();
}

/*!
  Description of destructor still missing
*/
ControlPanel::~ControlPanel()
{
  TRACE;
  delete _referenceModel;
}

void ControlPanel::setReferenceModel(GeophysicalModel * m)
{
  TRACE;
  delete _referenceModel;
  _referenceModel=m;
  QList<ModelSlider *> sliders=findChildren<ModelSlider *>();
  for(QList<ModelSlider *>::iterator it=sliders.begin();it!=sliders.end();it++) {
    (*it)->setReferenceModel(_referenceModel);
  }
}

void ControlPanel::clear()
{
  TRACE;
  QList<ModelSlider *> sliders=findChildren<ModelSlider *>();
  for(QList<ModelSlider *>::iterator it=sliders.begin();it!=sliders.end();it++) {
    delete *it;
  }
}

ModelSlider * ControlPanel::slider(QString sliderName)
{
  TRACE;
  QList<ModelSlider *> sliders=findChildren<ModelSlider *>();
  for(QList<ModelSlider *>::iterator it=sliders.begin();it!=sliders.end();it++) {
    if((*it)->title()==sliderName) {
      return *it;
    }
  }
  return 0;
}

void ControlPanel::on_addSliderBut_clicked()
{
  TRACE;
  ModelSlider * slider=new ModelSlider(this);
  slider->setReferenceModel(_referenceModel);
  QVBoxLayout * layout=static_cast<QVBoxLayout *>(sliderList->widget()->layout());
  if(layout->count()<2) {
    slider->setTitle(tr("Unamed"));
  } else {
    ModelSlider * last=static_cast<ModelSlider *>(static_cast<QWidgetItem *>(layout->itemAt(layout->count()-2))->widget());
    slider->setTitle(last->title());
    slider->setCode(last->code());
  }
  layout->insertWidget(layout->count()-1, slider);
  connect(slider, SIGNAL(modelChanged( GeophysicalModel* )),
           this, SIGNAL(modelChanged( GeophysicalModel*)) );
}

void ControlPanel::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  QList<ModelSlider *> sliders=findChildren<ModelSlider *>();
  for(QList<ModelSlider *>::iterator it=sliders.begin();it!=sliders.end();it++) {
    (*it)->xml_save(s, context);
  }
}

XMLMember ControlPanel::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  Q_UNUSED(context)if(tag=="ModelSlider" ) {
    ModelSlider * slider=new ModelSlider;
    QVBoxLayout * layout=static_cast<QVBoxLayout *>(sliderList->widget()->layout());
    layout->insertWidget(layout->count()-1, slider);
    connect(slider, SIGNAL(modelChanged( GeophysicalModel* )),
            this, SIGNAL(modelChanged( GeophysicalModel*)) );
    slider->setReferenceModel(_referenceModel);
    return XMLMember(slider);
  }
  return XMLMember(XMLMember::Unknown);
}

void ControlPanel::load(QString fileName)
{
  TRACE;
  clear();
  XMLErrorReport xmler(XMLErrorReport::Read);
  xmler.setTitle(tr("Open control panel description"));
  xmler.setFileName(fileName);
  XMLHeader hdr(this);
  xmler.exec(hdr.xml_restoreFile(fileName));
}

void ControlPanel::on_loadBut_clicked()
{
  TRACE;
  QString str=Message::getOpenFileName(tr("Open control panel description"),
                tr("Control panel file (*.cpanel)"));
  if( !str.isEmpty()) {
    load(str);
  }
}

void ControlPanel::on_saveBut_clicked()
{
  TRACE;
  static QString title=tr("Save control panel description");
  QString fileName=Message::getSaveFileName(title, tr("Control panel file (*.cpanel)"));
  if(!fileName.isEmpty()) {
    XMLErrorReport xmler(XMLErrorReport::Read);
    xmler.setTitle(title);
    xmler.setFileName(fileName);
    XMLHeader hdr(this);
    xmler.exec(hdr.xml_saveFile(fileName));
  }
}
