/***************************************************************************
**
**  This file is part of gpfksimulator.
**
**  gpfksimulator is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpfksimulator is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-12-09
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SOURCESIGNAL_H
#define SOURCESIGNAL_H

#include "SourceParameters.h"

class MediumParameters;

class SourceSignal
{
public:
  SourceSignal();
  ~SourceSignal();

  void setParameters(SourceParameters::WaveModel wm,
                     const SourceParameters& param,
                     const MediumParameters& medium,
                     int blockCount,
                     const VectorList<Point2D>& stations);
  Complex stationSignal(int blockIndex, int stationIndex) const {return _sigs[blockIndex].at(stationIndex);}
  const SourceParameters& parameters() const {return _param;}
private:
  static GlobalRandom * _phaseGenerator;
  VectorList<Complex> * _sigs;
  SourceParameters _param;
};

#endif // SOURCESIGNAL_H

