/***************************************************************************
**
**  This file is part of gpfksimulator.
**
**  gpfksimulator is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpfksimulator is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-06
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SOURCEDELEGATE_H
#define SOURCEDELEGATE_H

#include <QGpGuiTools.h>

#include "SourceParameters.h"

class SourceDelegate : public ItemDelegate
{
  Q_OBJECT
public:
  SourceDelegate(QObject *parent);
  ~SourceDelegate();

  void setWaveModel(SourceParameters::WaveModel wm) {_waveModel=wm;}

  QWidget * createEditor(QWidget *parent, const QStyleOptionViewItem & style, const QModelIndex &index) const;
  void setEditorData(QWidget *editor, const QModelIndex &index) const;
  QSize sizeHint(const QStyleOptionViewItem & option, const QModelIndex & index) const;
  void paint (QPainter * painter, const QStyleOptionViewItem & option, const QModelIndex & index) const;
public slots:
  void colorClicked(const QModelIndex& index);
private:
  int colorColumn() const;

  SourceParameters::WaveModel _waveModel;
};

#endif // SOURCEDELEGATE_H
