/***************************************************************************
**
**  This file is part of gpfksimulator.
**
**  gpfksimulator is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpfksimulator is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-03-27
**  Copyright: 2006-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef RESPONSESIMULATOR_H
#define RESPONSESIMULATOR_H

#include <SciFigs.h>
#include <ArrayCore.h>

#include "SourceParameters.h"
#include "MediumParameters.h"
#include "Parameters.h"
#include "SourceList.h"
#include "ui_Simulator.h"
#include "SimulatedCrossSpectrum.h"

class Simulator : public QWidget, public Ui::Simulator
{
  Q_OBJECT
public:
  Simulator(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);
  ~Simulator();

  void setParameters(const Parameters& param) {_parameters=param;}
  void init(const QList<NamedPoint>& array, double sampling);
  void initUserValues();
  void setKmax(double kmax);
  void setCrossSection(bool c) {_crossSection=c;}
  void scan(const QStringList& sources);
  void fitCrossSpectrum(GridSearch2D * grid);
public slots:
  bool save(QString fileName=QString());
  bool load(QString fileName=QString());
protected slots:
  void setWaveModel();
  void on_randomBut_clicked();
  void on_frequencyEdit_valueChanged(double f);
  void on_processType_currentIndexChanged(int index);
  void on_verticalNoiseEdit_valueChanged(double a);
  void on_horizontalNoiseEdit_valueChanged(double a);
  void on_plotTypeEdit_currentIndexChanged(int index);
  void on_fixedEll_valueChanged(double value);
  void on_sensorRotationEdit_valueChanged(double a);
  void on_blockCountEdit_valueChanged(int a);
  void on_attenuationEdit_valueChanged(double q);
  void on_attenuationButton_toggled(bool checked);
  void on_gridSizeEdit_valueChanged(double k);
  void on_addSource_clicked();
  void on_removeSource_clicked();
  void on_crossSectionBut_clicked();
  void on_maximaBut_clicked();
  void setSource(QModelIndex topLeft,QModelIndex bottomRight);
  void setAllSources();
  void displaySource(int index);
  void setKmax();
  double theoreticalKmax() const;
private:
  void updateMax();
  void ellipticitySign();
  void addSourceMarkers();
  void setSource(int iSrc);
  void updateMap();
  double distanceToSources(const Vector<double>& k);
  void resizeEvent(QResizeEvent *);
  void averageSigma();

  SourceList _sources;
  MediumParameters _medium;
  SimulatedArrayStations * _array;
  ArraySelection * _arraySelection;

  Parameters _parameters;
  SimulatedCrossSpectrum * _crossSpectrum;
  FKCache * _cache;

  double _sampling;

  CircleViewer * _velocityLayer;
  LineLayer * _azimuthLayer;
  NameLineLayer * _maxLayer;
  LiveGridLayer * _gridLayer;
  CircleMask * _kLayer;
  MeshLayer * _fkMeshLayer;

  QTimer _kmaxTimer;
  KmaxSolver * _kmaxSolver;

  bool _crossSection;
};

#endif // RESPONSESIMULATOR_H
