/***************************************************************************
**
**  This file is part of gpcoord.
**
**  gpcoord is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpcoord is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-06-19
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COORDREADER_H
#define COORDREADER_H

#include <QGpCoreTools.h>
#include <TapePositioningSystem.h>

class CoordReader : public ArgumentStdinReader
{
  TRANSLATIONS("CoordReader")
public:
  CoordReader();
  ~CoordReader();

  bool setOptions(int& argc, char ** argv);
  bool hasInput() const;
  bool terminate();
protected:
  virtual bool parse(QTextStream& s);
private:
  enum Mode {None, Distance, DistanceLookup, DistanceGeo, Azimuth, AzimuthGeo, AzimuthLookup,
             FromGeo, ToGeo, FromDMS, ToDMS, FromDM, ToDM, ToUTM, FromUTM, ToKML, FromKML,
             Translate, Rotate, Project, Average, Localize, LineMove, Lookup, TriangulateDistance,
             TriangulateAzimuth, FromDistances, InvertTranslationRotation, Misfit,
             ArrayLimits, ArrayPattern, UTMDeclination, MagDeclination, AllDistances,
             GenerateCircles, GenerateTriangles, GenerateRandom, GenerateMarkovChain, GenerateGridCircle, GenerateRandomGridCircle};
  enum FromDistancesOutMode {NoOutput=0, Mean=1, Raw=2, Ellipse=4, Clusters=8};

  bool arrayLimits(double& kmin, double& kmax);
  bool generateCircles();
  bool generateRandom();
  bool generateMarkovChain();
  bool generateGridCircle();
  bool generateRandomGridCircle();

  QList<NamedPoint> loadFile(const QString& fileName, bool& ok);
  bool acceptPoint(Point2D p) const;
  static void addZone(QList<Polygon>& zoneList, QList<NamedPoint>& newZone);
  void invertTranslationRotation();
  void misfit();
  bool triangulateDistance();


  Mode _mode;
  Angle::Mode _angleMode;
  FromDistancesOutMode _fromDistancesOutMode;
  Point _geoReference;
  Point _cartReference;
  Angle _angle;
  Point _translateVector;
  Point _average;
  int _averageCount;
  VectorList<Point2D> _array;
  VectorList<NamedPoint> _points;
  QMap<QString, Point> _refPoints;
  VectorList<Circle> _circles;
  VectorList<Line2D> _lines;
  QDate _date;
  GoogleEarthKML * _kml;
  QString _kmlFileName;
  UtmZone _utmZone;
  QString _origin, _north, _eastward;
  double _distanceStddev, _priorPrecision, _posteriorPrecision;
  Triangulator _fromDistanceFactory;
  int _clusterCount;
  ConsoleProgress * _progress;
  int _sensorCount, _firstIndex, _stepCount;
  Option<int> _circleCount;
  double _maximumRadius;
  Option<double> _radiusFactor;
  Option<double> _minimumDistance, _maximumStep, _maximumDeviation;
  QList<NamedPoint> _fixedSensors;
  QList<Polygon> _includeZones, _excludeZones;
  Polygon _polygon;
  QString _reportName;
  int _ns0, _ns, _nr;
};

#endif // COORDREADER_H
