/***************************************************************************
**
**  This file is part of geopsytfa.
**
**  geopsytfa is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsytfa is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-07-13
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ToolTFAd.h"

/*!
  \class ToolTFAd ToolTFAd.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ToolTFAd::ToolTFAd(QWidget * parent)
    : QWidget(parent)
{
  TRACE;
  setupUi(this);

  freqSamp->setFrequency();

  wavelet->morletFi->setToolTip(tr("This is just for computing the resolution in time and frequency. "
                                   "It has no influence on the computation of the Morlet transform."));
}

void ToolTFAd::getParameters(TFAParameters& param)
{
  TRACE;
  timeLimits->getParameters(param.range());
  freqSamp->getParameters(param.frequencySampling());
  wavelet->getParameters(param.wavelet());
}

void ToolTFAd::setParameters(const TFAParameters& param)
{
  TRACE;
  timeLimits->setParameters(param.range());
  freqSamp->setParameters(param.frequencySampling());
  wavelet->setParameters(param.wavelet());
}
