/***************************************************************************
**
**  This file is part of geopsyptmotion.
**
**  geopsyptmotion is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyptmotion is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-05-24
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PtMotionResults_H
#define PtMotionResults_H

#include <GeopsyCore.h>
#include <SciFigs.h>

class PtMotionResults : public GraphicSheetMenu
{
  Q_OBJECT
public:
  PtMotionResults(QWidget* parent=0);
  ~PtMotionResults();
  void createObjects(SubSignalPool * subPool);
  void updateSignals(const SubSignalPool * subPool, TimeRangeParameters& tlParam,
                      bool doFilter, const FilterParameters& fparam,
                      bool verticalPlane, double direction);
  void setLimits();
  void setPlotOtions(bool plotLines);
private:
  DoubleSignal * filtered(const DoubleSignal * sig, const FilterParameters& fparam);

  VectorList<XUniqueYColorLines *> _curveLayers;
};

#endif
