/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-19
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "SourceCoordinates.h"

/*!
  \class SourceCoordinates SourceCoordinates.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
SourceCoordinates::SourceCoordinates(QWidget * parent)
    : StationCoordinates(parent)
{
  TRACE;
  QVBoxLayout * vboxLayout=qobject_cast<QVBoxLayout *>(layout());
  ASSERT(vboxLayout);
  QHBoxLayout * hboxLayout=new QHBoxLayout();
  hboxLayout->setSpacing(6);
  hboxLayout->setContentsMargins(0, 0, 0, 0);
  hboxLayout->setObjectName(QString::fromUtf8("hboxLayoutSource"));

  QLabel * nameLabel=new QLabel(this);
  nameLabel->setObjectName(QString::fromUtf8("sourceNameLabel"));
  nameLabel->setText(tr("Source name pattern"));

  hboxLayout->addWidget(nameLabel);

  sourceNameEdit=new QComboBox(this);
  sourceNameEdit->setObjectName(QString::fromUtf8("sourceNameEdit"));
  QSizePolicy sizePolicy(static_cast<QSizePolicy::Policy>(7), static_cast<QSizePolicy::Policy>(0));
  sizePolicy.setHorizontalStretch(0);
  sizePolicy.setVerticalStretch(0);
  sizePolicy.setHeightForWidth(sourceNameEdit->sizePolicy().hasHeightForWidth());
  sourceNameEdit->setSizePolicy(sizePolicy);
  sourceNameEdit->setEditable(true);
  sourceNameEdit->setToolTip(tr("The names listed here above will be mapped with the names generated by this pattern."));
  sourceNameEdit->setWhatsThis(tr("<p>Pattern follow the same syntax as in 'Set header' menu, 'Return' variable must "
                                  " contain at the end the string corresponding to a source name in the list. Typically, "
                                  " we want to map short file names (without extension) to source names.</p>"
                                  "<ul>"
                                  "  <li><b>If</b> 'ShortFileName' contains the following names: 1001.dat, 1002.dat,...</li>"
                                  "  <li><b>If</b> you want to set the same source coordinates for all signals belonging to each "
                                  " file</li>"
                                  "  <li><b>If</b> the names associated with the source coordinates are prefixed by 'Shot_'</li>"
                                  "</ul>"
                                  "<p><b>Then</b> a good source name pattern can be:</p>"
                                  "<p>Shot_{Return=left(ShortFileName,length(ShortFileName)-4);}</p>"));
  sourceNameEdit->setEditText("Shot_{Return=left(ShortFileName,length(ShortFileName)-4);}");
  connect(sourceNameEdit, SIGNAL(editTextChanged(const QString& )),
           this, SLOT(on_sourceNameEdit_editTextChanged(const QString& )));

  hboxLayout->addWidget(sourceNameEdit);

  applyBut=new QPushButton(this);
  applyBut->setObjectName(QString::fromUtf8("applyBut"));
  applyBut->setText(tr("Apply"));
  applyBut->setEnabled(false);
  connect(applyBut, SIGNAL(clicked()), this, SLOT(on_applyBut_clicked()));

  hboxLayout->addWidget(applyBut);

  vboxLayout->addLayout(hboxLayout);

  sourceNameEdit->addItems(Settings::getHistory("SourceNamePattern"));
  setWindowTitle(tr("Source coordinates"));
}

QString SourceCoordinates::sourceNamePattern() const
{
  TRACE;
  return sourceNameEdit->currentText();
}

void SourceCoordinates::on_applyBut_clicked()
{
  TRACE;
  QString log;
  StreamRedirection sr(new StringStream(&log));
  _keyExpression.clear();
  if(!_keyExpression.setPattern(sourceNamePattern(), &_keyExpressionContext)) {
    Message::warning(MSG_ID, tr("Set sources"), tr("Error(s) while parsing source name pattern:\n\n%1").arg(log));
  } else {
    applyBut->setEnabled(false);
    StationCoordinates::init(_subPool);
  }
}

bool SourceCoordinates::init(SubSignalPool * subPool)
{
  TRACE;
  _subPool=subPool;
  on_applyBut_clicked();
  return true;
}

bool SourceCoordinates::initLookup()
{
  TRACE;
  QString log;
  StreamRedirection sr(new StringStream(&log));
  _keyExpression.clear();
  if(!_keyExpression.setPattern(sourceNamePattern(), &_keyExpressionContext)) {
    Message::warning(MSG_ID, tr("Set sources"), tr("Error(s) while parsing source name pattern:\n\n%1").arg(log));
    return false;
  } else {
    Settings::setHistory("SourceNamePattern", sourceNamePattern());
    return true;
  }
}

void SourceCoordinates::on_sourceNameEdit_editTextChanged(const QString& )
{
  TRACE;
  applyBut->setEnabled(true);
}

QString SourceCoordinates::keyName(Signal * sig)
{
  TRACE;
  _keyExpressionContext.setSignal(sig);
  return _keyExpression.value();
}
