/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-18
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PICKEVENTS_H
#define PICKEVENTS_H

#include <GeopsyGui.h>

namespace Ui {
  class PickEvents;
}

class PickEvents : public Dialog
{
  Q_OBJECT
public:
  PickEvents(QWidget * parent=nullptr);
  ~PickEvents();

  void setSubPool(SubPoolWindow * subPoolWin) {_subPoolWin=subPoolWin;}
  void updateAllFields();

  void pickEvents();
  void removeEvents();
  void updateSignals();
private slots:
  void on_previewButton_clicked();
private:
  Ui::PickEvents * ui;
  SubPoolWindow * _subPoolWin;
  VectorList<const SeismicEvent *> _myEvents;
};

#endif // PICKEVENTS_H
