/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-05-23
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GROUPWIDGET_H
#define GROUPWIDGET_H

#include <QtGui>

#include "ui_GroupWidget.h"

class MainWindow;

class GroupWidget : public QWidget, private Ui::GroupWidget
{
  Q_OBJECT
public:
  GroupWidget(QWidget * parent=nullptr);
  ~GroupWidget();

  void addActions() {groupView->addActions();}
  void expandAll();
  void setMode(GroupView::Mode m);
private slots:
  void on_mode_currentIndexChanged(int index);
  void on_selectButton_clicked();
private:
  QAction * browseAction;
  QAction * renameAction;
  QAction * sortAction;
};

#endif // GROUPWIDGET_H
