/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-05-23
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "GroupWidget.h"

/*!
  \class GroupWidget GroupWidget.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
GroupWidget::GroupWidget(QWidget * parent)
  : QWidget(parent)
{
  TRACE;
  setupUi(this);
  expandAll();

  findReplace->setHistoryBaseName("GroupWidgetFind");
  selectEdit->addItems(Settings::getHistory("GroupWidgetSelect"));

  setMode(GroupView::Browse);
}

/*!
  Description of destructor still missing
*/
GroupWidget::~GroupWidget()
{
  TRACE;
}

void GroupWidget::expandAll()
{
  TRACE;
  groupView->expandToDepth(0);
}

void GroupWidget::on_mode_currentIndexChanged(int index)
{
  TRACE;
  switch(index) {
  default:
    setMode(GroupView::Browse);
    break;
  case 1:
    setMode(GroupView::Signals);
    break;
  case 2:
    setMode(GroupView::Rename);
    break;
  case 3:
    setMode(GroupView::Sort);
    break;
  }
}

void GroupWidget::on_selectButton_clicked()
{
  TRACE;
  QRegularExpression exp(selectEdit->currentText());
  Settings::setHistory("GroupWidgetSelect", exp.pattern());
  selectEdit->clear();
  selectEdit->addItems(Settings::getHistory("GroupWidgetSelect"));

  groupView->select(exp);
}

void GroupWidget::setMode(GroupView::Mode m)
{
  TRACE;
  switch(m) {
  case GroupView::Browse:
  case GroupView::Signals:
    findReplace->hide();
    break;
  case GroupView::Rename:
    findReplace->show();
    break;
  case GroupView::Sort:
    findReplace->hide();
    break;
  }
  groupView->setMode(m);
}
