/***************************************************************************
**
**  This file is part of dinvermatlab.
**
**  This file is distributed under the terms of the Geopsy.org Commercial
**  License appearing in the file LICENSE.COMMERCIAL included in the packaging
**  of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See Geopsy.org Commercial License for
**  more details.
**
**  You should have received a copy of the Geopsy.org Commercial License
**  along with this program. If not, see <http://www.geopsy.org>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-11-23
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FORWARD_H
#define FORWARD_H

#ifdef GP_MATLAB_LIBS
#include <engine.h>
#endif

#include <DinverCore.h>

class MatlabTarget;

class Forward : public AbstractForward
{
  TRANSLATIONS("Forward")
public:
  Forward();
  ~Forward();

  bool setParam(ParamSpaceScript * param);
  bool setTarget(MatlabTarget * target, bool skipTest);

  MatlabTarget * target() const {return _target;}
  ParamSpaceScript * parameters() const {return _param;}

  virtual AbstractForward * clone() const;
  virtual double misfit(bool& ok);

  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_polish(XML_POLISH_ARGS);
private:
  MatlabTarget * _target;
  ParamSpaceScript * _param;
#ifdef GP_MATLAB_LIBS
  Engine * _matlab;
#endif
};

#endif // FORWARD_H
