/***************************************************************************
**
**  This file is part of dinverext.
**
**  dinverext is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverext is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-10
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef FORWARD_H
#define FORWARD_H

#include <DinverGui.h>

class ExtTarget;

class Forward : public AbstractForward
{
  TRANSLATIONS("Forward")
public:
  Forward();
  ~Forward();

  bool setParam(ParamSpaceScript * param);
  bool setTarget(ExtTarget * target);

  ExtTarget * target() const {return _target;}
  ParamSpaceScript * parameters() const {return _param;}

  virtual AbstractForward * clone() const;
  virtual int maximumThreadCount() const {return INT_MAX;}

  virtual double misfit(bool& ok);
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
  virtual bool xml_polish(XML_POLISH_ARGS);
private:
  ExtTarget * _target;
  ParamSpaceScript * _param;
  QString _dirPath;
};

#endif // FORWARD_H
