/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-28
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ModelThreadInfo_H
#define ModelThreadInfo_H

#include <DinverCore.h>

class InversionThread;
class PSViewer;

class ModelThreadInfo
{
public:
  inline ModelThreadInfo(const InversionThread * t, const SetIndex& index);

  bool operator<(const ModelThreadInfo& o) const;
  const InversionThread * thread() const {return _thread;}
  const SetIndex& index() const {return _index;}
private:
  const InversionThread * _thread;
  SetIndex _index;
};

typedef QList<InversionThread *> ThreadList;
typedef QList<ModelThreadInfo> ModelThreadList;
typedef VectorList<PSViewer*> PSViewerVector;
typedef QList<PSViewer*> PSViewerList;

inline ModelThreadInfo::ModelThreadInfo(const InversionThread * t, const SetIndex& index)
{
  _thread=t;
  _index=index;
}

#endif
