/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-05-17
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "SciFigsXMLEditor.h"

namespace SciFigs {

  /*!
    \class SciFigsXMLEditor SciFigsXMLEditor.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  SciFigsXMLEditor::SciFigsXMLEditor(QWidget * parent)
    : XMLEditor(parent)
  {
    TRACE;
    model()->rootItem()->setTag("SciFigs");
  }

  void SciFigsXMLEditor::setAxisWindowProperty(bool e, QString tag)
  {
    TRACE;
    XMLGenericItem * queryItem=new XMLGenericItem("AxisWindow");
    new XMLGenericItem(tag, queryItem);
    QList<XMLGenericItem *> itemList;
    model()->rootItem()->find(itemList, queryItem);
    delete queryItem;
    setEnabled(e, itemList);
  }

  void SciFigsXMLEditor::setAxisProperty(bool e, QString tag, bool horizontal)
  {
    TRACE;
    XMLGenericItem * queryItem=new XMLGenericItem("AxisWindow");
    XMLGenericItem * axisItem=new XMLGenericItem( "Axis", queryItem);
    if(horizontal) {
      axisItem->addAttribute( "orientation", "Horizontal" );
    } else {
      axisItem->addAttribute( "orientation", "Vertical" );
    }
    new XMLGenericItem(tag, axisItem);
    QList<XMLGenericItem *> itemList;
    model()->rootItem()->find(itemList, queryItem);
    delete queryItem;
    setEnabled(e, itemList);
  }

  void SciFigsXMLEditor::setLayers(bool e)
  {
    TRACE;
    XMLGenericItem * queryItem=new XMLGenericItem("AxisWindow");
    XMLGenericItem * layerItem=new XMLGenericItem( "", new XMLGenericItem( "GraphContents", queryItem) );
    layerItem->addAttribute("layer");
    QList<XMLGenericItem *> itemList;
    model()->rootItem()->find(itemList, queryItem);
    delete queryItem;
    setEnabled(e, itemList);
  }

} // namespace SciFigs
