/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-05-30
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PLOTLINE2D_H
#define PLOTLINE2D_H

#include "AbstractLine.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT PlotLine2D : public AbstractLine
{
  TRANSLATIONS("PlotLine2D")
public:
  PlotLine2D() {}
  PlotLine2D(const PlotLine2D& o);

  AbstractLine * clone() const;
  void operator=(const AbstractLine& o);
  bool canCopy(const AbstractLine& o) const;

  int count() const {return _curve.count();}
  void clear() {_curve.clear();}
  void append() {_curve.append(Point2D());}
  void insert(int index) {_curve.insert(index, Point2D());}
  void removeLast() {_curve.remove(_curve.count()-1);}
  bool isSorted() const {return _curve.isSorted();}
  void checkSort() {_curve.checkSort();}
  void indexRange(double xMin, double xMax, int& indexMin, int& indexMax) const {
    _curve.indexRange(xMin, xMax, indexMin, indexMax);
  }
  Point point(int index, const CurvePointOptions *) const {return _curve.constAt(index);}
  void setX(int index, double v) {_curve.setX(index, v);}
  void setY(int index, double v, const CurvePointOptions *) {_curve.setY(index, v);}
  void setZ(int, double, const CurvePointOptions *) {}

  const Curve<Point2D>& curve() const {return _curve;}
  Curve<Point2D>& curve() {return _curve;}
  void setCurve(const Curve<Point2D>& curve);
  void setCurve(const Curve<Point2D>& curve, const Pen& pen, const Symbol& sym);
  void setCurve(VectorList<double> * dataX, VectorList<double> * dataY);
protected:
  Curve<Point2D> _curve;
};

} // namespace SciFigs

#endif // PLOTLINE2D.H
