/***************************************************************************
**
**  This file is part of SciFigs.
**
**  SciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  SciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-01-22
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PAGESIZEPROPERTIES_H
#define PAGESIZEPROPERTIES_H

#include <QGpGuiTools.h>

#include "ui_PageSizeProperties.h"

namespace SciFigs {

  class GraphicSheet;

  class PageSizeProperties : public PropertyWidget, private Ui::PageSizeProperties
  {
    Q_OBJECT
  public:
    PageSizeProperties(QWidget * parent=nullptr);

    enum Properties {PaperSize, Unit, Width, Height, Orientation};

    static QPageSize::PageSizeId item2paperSize(int index);
    static int paperSize2item(QPageSize::PageSizeId id);
    static QPageSize::Unit item2unit(int index);
    static int unit2item(QPageSize::Unit unit);
    static QPageLayout::Orientation item2orientation(int index);
    static int orientation2item(QPageLayout::Orientation orientation);

    void setSheet(const GraphicSheet * s) {_sheet=s;}
    void setUnit(QPageSize::Unit u) {_unit=u;}
  private slots:
    void on_paperSizeEdit_activated(int index);
    void on_paperSizeEdit_currentIndexChanged(int index);
    void on_unitEdit_currentIndexChanged(int index);
  private:
    PropertyValue::WidgetType determineCustomWidgetType(int pid, QWidget * w, QWidget * label);
    bool connectCustomWidget(PropertyValue & p);
    bool setCustomWidget(PropertyValue & p);
    QVariant customWidgetValue(PropertyValue & p);
    void setPaperSizes();

    QPageSize::Unit _unit;
    static QList<QPair<QString, QPageSize::PageSizeId>> _paperSizes;
    const GraphicSheet * _sheet;
  };

} // namespace SciFigs

#endif // PAGESIZEPROPERTIES_H

