/***************************************************************************
**
**  This file is part of SciFigs.
**
**  SciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  SciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-01-22
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PAGESIZE_H
#define PAGESIZE_H

#include <QGpGuiTools.h>

#include "SciFigsDLLExport.h"

namespace SciFigs {

  class SCIFIGS_EXPORT PageSize: public XMLClass
  {
  public:
    PageSize();

    const QString& xml_tagName() const {return xmlPageSizeTag;}
    static const QString xmlPageSizeTag;

    QPageSize::PageSizeId paperSize() const {return _paperSize;}
    void setPaperSize(QPageSize::PageSizeId id);
    bool setPaperSize(QString id);
    QString paperSizeString() const;

    QPageSize::Unit unit() const {return _unit;}
    void setUnit(QPageSize::Unit u) {_unit=u;}
    bool setUnit(QString u);
    QString unitString() const;

    double width() const {return _width;}
    void setWidth(double w) {if(w>0.0) _width=w;}

    double height() const {return _height;}
    void setHeight(double h) {if(h>0.0) _height=h;}

    QPageLayout::Orientation orientation() const {return _orientation;}
    void setOrientation(QPageLayout::Orientation o) {_orientation=o;}
    bool setOrientation(QString o);
    QString orientationString() const;

    void properties(PropertyWidget * w) const;
    void setProperty(int pid, QVariant val);

    QPageLayout pageLayout() const;
  protected:
    void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
    XMLMember xml_member(XML_MEMBER_ARGS);
    bool xml_setProperty(XML_SETPROPERTY_ARGS);
    bool xml_polish(XML_POLISH_ARGS);
  private:
    QPageSize::PageSizeId _paperSize;
    QPageSize::Unit _unit;
    double _width, _height;
    QPageLayout::Orientation _orientation;
  };

} // namespace SciFigs

#endif // PAGESIZE_H

