/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-01-31
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MOUSETRACKING_H
#define MOUSETRACKING_H

#include "SciFigsDLLExport.h"
#include "LayerMouseTracking.h"

namespace SciFigs {

class SCIFIGS_EXPORT MouseTracking : private QList<LayerMouseTracking>
{
public:
  MouseTracking() {_rectangle=0; _active=true;}
  ~MouseTracking() {delete _rectangle;}

  void add(const LayerMouseTracking& l);
  void remove(int i);

  bool isEmpty() const {return QList<LayerMouseTracking>::isEmpty();}
  int indexOf(const GraphContentsLayer * layer, int id=-1) const;
  bool contains(const GraphContentsLayer * layer, int id=-1) const {return indexOf(layer, id)>-1;}
  const LayerMouseTracking& activeLayer() const {return first();}

  bool isRectangle() const;
  bool isRectangleVisible() const;
  QPen pen() const;
  QBrush brush() const;

  QRect * rectangle() const {return _rectangle;}
  void initRectangle(const QPoint& topLeft);
  void resetRectangle();
  bool isEmptyRectangle() const {return abs(_rectangle->width())<5 && abs(_rectangle->height())<5;}

  bool isActive() const {return _active;}
  void setActive(bool a) {_active=a;}
private:
  QRect * _rectangle;
  bool _active;
};

} // namespace SciFigs

#endif // MOUSETRACKING_H
