/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-10-30
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LINELAYERPROPERTIES_H
#define LINELAYERPROPERTIES_H

#include <QGpGuiTools.h>

#include "ui_LineLayerProperties.h"
#include "SciFigsDLLExport.h"
#include "LineLayer.h"

namespace SciFigs {

  class AbstractLine;
  class LegendProperties;

  class SCIFIGS_EXPORT LineLayerProperties : public PropertyWidget, private Ui::LineLayerProperties
  {
    Q_OBJECT
  public:
    LineLayerProperties(QWidget * parent=nullptr);
    ~LineLayerProperties();

    enum Properties {SignThreshold, ErrorBar};

    void addLayer(LineLayer * layer);
    void removeLayer(LineLayer * layer);

    QAction * addLineAction(QString title, QString toolTip);
    LineLayer * currentLayer() const;
    int currentLine() const;
    void updateCurrentLine();
    void updateCurrentLayer();

    static int errorBar2item(LineLayer::ErrorBar e);
    static LineLayer::ErrorBar item2errorBar(int index);
  private slots:
    void on_legendBut_clicked();
    void save();
    void saveAll();
    void remove();
    void on_currentLayerCombo_currentIndexChanged(int index);
    void on_lineScroll_valueChanged(int);
    void on_visibleBut_toggled(bool checked);
    void commitLegend();
  private:
    void setLayerList();
    void save3Columns(QString fileName, int beginLineIndex, int endLineIndex);
    void setEnableCurveButtons(bool b);
    AbstractLine * line(int index) const;
    static bool layerLessThan(const LineLayer * l1, const LineLayer * l2);

    QSet<LineLayer *> _layerSet;
    QList<LineLayer *> _layerList;
    LegendProperties * _legendEditor;
    QAction * _removeAction;
  };

} // namespace SciFigs

#endif // LINELAYERPROPERTIES_H
