/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-01-31
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LAYERMOUSETRACKING_H
#define LAYERMOUSETRACKING_H

#include <QtGui>

#include "SciFigsDLLExport.h"

namespace SciFigs {

class GraphContentsLayer;

class SCIFIGS_EXPORT LayerMouseTracking
{
public:
  LayerMouseTracking(GraphContentsLayer * layer);
  LayerMouseTracking(const LayerMouseTracking& o) {operator=(o);}
  ~LayerMouseTracking();

  void operator=(const LayerMouseTracking& o);
  GraphContentsLayer * layer() const {return _layer;}

  void setRectangle(bool r) {_rectangle=r;}
  bool rectangle() const {return _rectangle;}

  void showRectangle() {_showRectangle=true;}
  void hideRectangle() {_showRectangle=false;}
  bool isRectangleVisible() const {return _showRectangle;}

  const QPen& pen() const {return _pen;}
  void setPen(const QPen& p) {_pen=p;}

  const QBrush& brush() const {return _brush;}
  void setBrush(const QBrush& b) {_brush=b;}

  void setIdleCursor(const QPixmap & pixmap, int hotX=-1, int hotY=-1) {_idleCursor=new QCursor(pixmap,hotX,hotY);}
  void setIdleCursor(Qt::CursorShape shape) {_idleCursor=new QCursor(shape);}
  QCursor * idleCursor() const {return _idleCursor;}

  void setActionCursor(const QPixmap & pixmap, int hotX=-1, int hotY=-1) {_actionCursor=new QCursor(pixmap,hotX,hotY);}
  void setActionCursor(Qt::CursorShape shape) {_actionCursor=new QCursor(shape);}
  QCursor * actionCursor() const {return _actionCursor;}

  void setId(int i) {_id=i;}
  int id() const {return _id;}
private:
  GraphContentsLayer * _layer;
  bool _rectangle, _showRectangle;
  QPen _pen;
  QBrush _brush;
  QCursor * _idleCursor;
  QCursor * _actionCursor;
  int _id;
};

} // namespace SciFigs

#endif // LAYERMOUSETRACKING_H
