/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-01-31
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>

#include "LayerMouseTracking.h"

namespace SciFigs {

  /*!
    \class LayerMouseTracking LayerMouseTracking.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  LayerMouseTracking::LayerMouseTracking(GraphContentsLayer * layer)
    : _pen(Qt::DotLine)
  {
    TRACE;
    _layer=layer;
    _rectangle=false;
    _showRectangle=false;
    _idleCursor=0;
    _actionCursor=0;
    _id=-1;
  }

  /*!
    Description of destructor still missing
  */
  LayerMouseTracking::~LayerMouseTracking()
  {
    TRACE;
    delete _idleCursor;
    delete _actionCursor;
  }

  void LayerMouseTracking::operator=(const LayerMouseTracking& o)
  {
    _layer=o._layer;
    _rectangle=o._rectangle;
    _showRectangle=o._showRectangle;
    _pen=o._pen;
    _brush=o._brush;
    if(o._idleCursor) {
      _idleCursor=new QCursor(*o._idleCursor);
    } else {
      _idleCursor=nullptr;
    }
    if(o._actionCursor) {
      _actionCursor=new QCursor(*o._actionCursor);
    } else {
      _actionCursor=nullptr;
    }
    _id=o._id;
  }

} // namespace SciFigs
