/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-11-03
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GRAPHCONTENTLAYERFACTORY_H
#define GRAPHCONTENTLAYERFACTORY_H

#include <QGpCoreTools.h>

#include "SciFigsDLLExport.h"
#include "GraphContentsLayer.h"

namespace SciFigs {

  #define REGISTER_GRAPHCONTENTLAYER(_className_, _tagName_) \
    XMLREGISTER_HEAD(GraphContentsLayerFactory, XMLClassCreator, _className_, _tagName_) \
    XMLREGISTER_METAOBJECT(_className_) \
    XMLREGISTER_TAIL(_className_)

  #define SYNONYM_GRAPHCONTENTLAYER(_synName_, _tagName_) \
    XMLSYNONYM(GraphContentsLayerFactory, _synName_, _tagName_)

  class SCIFIGS_EXPORT GraphContentsLayerFactory : public XMLClassFactory
  {
  public:
    inline GraphContentsLayer * create(int id) const;
    inline GraphContentsLayer * create(const QString& tag) const;

    static void init();
    static GraphContentsLayerFactory * instance() {init(); return _self;}
  private:
    static GraphContentsLayerFactory * _self;
  };

  inline GraphContentsLayer * GraphContentsLayerFactory::create(int id) const
  {
    return static_cast<GraphContentsLayer *>(XMLClassFactory::create(id));
  }

  inline GraphContentsLayer * GraphContentsLayerFactory::create(const QString& tag) const
  {
    return static_cast<GraphContentsLayer *>(XMLClassFactory::create(tag));
  }

} // namespace SciFigs

#endif // GRAPHCONTENTLAYERFACTORY_H
