/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-02-03
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FONT_H
#define FONT_H

#include <QtGui>

#include "SciFigsGlobal.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

  class SCIFIGS_EXPORT Font : public QFont
  {
  public:
    Font();
    Font(const QFont& o) {operator=(o);}
    ~Font();

    void operator=(const QFont& f);

    void setFont(QPainter& p, double dotpercm) const;

    bool fromString(const QString& s);
    QString toString() const;

    QRectF boundingRect(const QString& text, int length=INT_MAX, int flags=Qt::AlignLeft | Qt::AlignTop) const;
    const QFont& screenFont() const {return _screenFont;}

    static double scale(QFont& f, double scale, bool *changed=nullptr);
    static const char * referenceText() {return _refText;}
  private:
    void setScreenScale();

    double _refWidth;
    double _screenScale;
    QFont _screenFont;
    static const char * _refText;
  };

} // namespace SciFigs

#endif // FONT_H

