/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-19
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ComplexStatisticalLine.h"
#include "LineFactory.h"

namespace SciFigs {

/*!
  \class ComplexStatisticalLine ComplexStatisticalLine.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const QString ComplexStatisticalLine::xmlComplexStatisticalLineTag="ComplexStatisticalLine";

REGISTER_LINE(ComplexStatisticalLine, "ComplexStatisticalLine")

ComplexStatisticalLine::ComplexStatisticalLine(const ComplexStatisticalLine& o)
  : AbstractLine(o)
{
  TRACE;
  _curve=o._curve;
}

AbstractLine * ComplexStatisticalLine::clone() const
{
  TRACE;
  return new ComplexStatisticalLine(*this);
}

bool ComplexStatisticalLine::canCopy(const AbstractLine& o) const
{
  TRACE;
  return dynamic_cast<const ComplexStatisticalLine *>(&o);
}

void ComplexStatisticalLine::operator=(const AbstractLine& o)
{
  TRACE;
  const ComplexStatisticalLine * co=static_cast<const ComplexStatisticalLine *>(&o);
  ASSERT(co);
  _curve=co->_curve;
  AbstractLine::operator=(o);
}

Point ComplexStatisticalLine::point(int index, const CurvePointOptions * options) const
{
  TRACE;
  const AbstractComplexPointOptions * co=static_cast<const AbstractComplexPointOptions *>(options);
  const ComplexStatisticalPoint& dp=_curve.constAt(index);
  Point p;
  p.setX(dp.x());
  p.setZ(dp.stddev());
  if(co) {
    p.setY(co->toDouble(dp.x(), dp.mean()));
  } else {
    ComplexPointOptions co;
    p.setY(co.toDouble(dp.x(), dp.mean()));
  }
  return p;
}

void ComplexStatisticalLine::setY(int index, double v, const CurvePointOptions * options)
{
  TRACE;
  const AbstractComplexPointOptions * co=static_cast<const AbstractComplexPointOptions *>(options);
  ComplexStatisticalPoint& p=_curve.constXAt(index);
  Complex c=p.mean();
  if(co) {
    co->fromDouble(p.x(), c, v);
  } else {
    ComplexPointOptions co;
    co.fromDouble(p.x(), c, v);
  }
  p.setMean(c);
}

} // namespace SciFigs
