/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-11-02
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "RefractionLine.h"

namespace QGpGuiWave {

/*!
    \class RefractionLine RefractionLine.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  const QString RefractionLine::xmlRefractionLineTag="RefractionLine";

  RefractionLine::RefractionLine(const RefractionLine& o)
    : AbstractLine(o)
  {
    TRACE;
    _curve=o._curve;
  }

  AbstractLine * RefractionLine::clone() const
  {
    TRACE;
    return new RefractionLine(*this);
  }

  bool RefractionLine::canCopy(const AbstractLine& o) const
  {
    TRACE;
    return dynamic_cast<const RefractionLine *>(&o);
  }

  void RefractionLine::operator=(const AbstractLine& o)
  {
    TRACE;
    const RefractionLine * co=dynamic_cast<const RefractionLine *>(&o);
    ASSERT(co);
    _curve=co->_curve;
    AbstractLine::operator=(o);
  }

  Point RefractionLine::point(int index, const CurvePointOptions *) const
  {
    TRACE;
    Point p;
    const RealStatisticalPoint& dp=_curve.constAt(index);
    p.setX(dp.x());
    p.setY(dp.mean());
    p.setZ(dp.stddev());
    return p;
  }

} // namespace QGpGuiWave
