/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-09-21
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "ModalLine.h"

namespace QGpGuiWave {

/*!
  \class ModalLine ModalLine.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const QString ModalLine::xmlModalLineTag="RealStatisticalLine";

ModalLine::ModalLine(const ModalLine& o)
  : AbstractLine(o)
{
  TRACE;
  _curve=o._curve;
}

AbstractLine * ModalLine::clone() const
{
  TRACE;
  return new ModalLine(*this);
}

bool ModalLine::canCopy(const AbstractLine& o) const
{
  TRACE;
  return dynamic_cast<const ModalLine *>(&o);
}

void ModalLine::operator=(const AbstractLine& o)
{
  TRACE;
  const ModalLine * co=static_cast<const ModalLine *>(&o);
  ASSERT(co);
  _curve=co->_curve;
  AbstractLine::operator=(o);
}

Point ModalLine::point(int index, const CurvePointOptions *) const
{
  TRACE;
  Point p;
  const FactoryPoint& dp=_curve.constAt(index);
  p.setX(dp.x());
  p.setY(dp.mean());
  p.setZ(dp.stddev());
  return p;
}

} // namespace QGpGuiWave
