/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-25
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "MagnetoTelluricLine.h"

namespace QGpGuiWave {

  const QString MagnetoTelluricLine::xmlMagnetoTelluricLineTag="Line";

  MagnetoTelluricLine::MagnetoTelluricLine(const MagnetoTelluricLine& o)
    : AbstractLine(o)
  {
    TRACE;
    _curve=o._curve;
  }

  AbstractLine * MagnetoTelluricLine::clone() const
  {
    TRACE;
    return new MagnetoTelluricLine(*this);
  }

  bool MagnetoTelluricLine::canCopy(const AbstractLine& o) const
  {
    TRACE;
    return dynamic_cast<const MagnetoTelluricLine *>(&o);
  }

  void MagnetoTelluricLine::operator=(const AbstractLine& o)
  {
    TRACE;
    const MagnetoTelluricLine * co=static_cast<const MagnetoTelluricLine *>(&o);
    ASSERT(co);
    _curve=co->_curve;
    AbstractLine::operator=(o);
  }

  Point MagnetoTelluricLine::point(int index, const CurvePointOptions * options) const
  {
    TRACE;
    const MagnetoTelluricPointOptions * co=static_cast<const MagnetoTelluricPointOptions *>(options);
    const MagnetoTelluricPoint& dp=_curve.constAt(index);
    Point p;
    p.setX(dp.x());
    p.setZ(dp.stddev());
    if(co) {
      p.setY(co->toDouble(dp.x(), dp.mean()));
    } else {
      ComplexPointOptions co;
      p.setY(co.toDouble(dp.x(), dp.mean()));
    }
    return p;
  }

  void MagnetoTelluricLine::setY(int index, double v, const CurvePointOptions * options)
  {
    TRACE;
    const MagnetoTelluricPointOptions * co=static_cast<const MagnetoTelluricPointOptions *>(options);
    MagnetoTelluricPoint& p=_curve.constXAt(index);
    Complex c=p.mean();
    if(co) {
      co->fromDouble(p.x(), c, v);
    } else {
      MagnetoTelluricPointOptions co;
      co.fromDouble(p.x(), c, v);
    }
    p.setMean(c);
  }

} // namespace QGpGuiWave
