/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  QGpGuiTools is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiTools is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-21
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TABLEVIEW_H
#define TABLEVIEW_H

#include <QtWidgets>

#include "QGpGuiToolsDLLExport.h"
#include "ItemDelegate.h"

namespace QGpGuiTools {

  class QGPGUITOOLS_EXPORT TableView : public QTableView
  {
    Q_OBJECT
  public:
    TableView(QWidget * parent=nullptr);
    ~TableView();

    void setItemDelegate(ItemDelegate * d);
    void setBackgroundMessage(const QString& msg);
  protected:
    bool eventFilter(QObject * o, QEvent * e);
  protected slots:
    virtual void changeAllRows(const QModelIndex& index, StringDiff string);
  signals:
    void allDataChanged() const;
  private:
    QString _backgroundMessage;
  };

} // namespace QGpGuiTools

#endif // TABLEVIEW_H

