/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-30
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "RegExpRowSelector.h"
#include "Settings.h"

namespace QGpGuiTools {

  /*!
    \class RegExpRowSelector RegExpRowSelector.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  RegExpRowSelector::RegExpRowSelector(QWidget * parent)
    : QWidget(parent)
  {
    TRACE;
    QHBoxLayout * hboxLayout=new QHBoxLayout(this);
    hboxLayout->setSpacing(6);
    hboxLayout->setContentsMargins(0, 0, 0, 0);

    _pattern=new QComboBox(this);
    QSizePolicy sizePolicy(QSizePolicy::Expanding, QSizePolicy::Fixed);
    sizePolicy.setHorizontalStretch(0);
    sizePolicy.setVerticalStretch(0);
    sizePolicy.setHeightForWidth(_pattern->sizePolicy().hasHeightForWidth());
    _pattern->setSizePolicy(sizePolicy);
    _pattern->setEditable(true);
    _pattern->setToolTip(tr("All rows of the above view that contain this regular expression are selected.\n"
                            "Column joints are translated to TAB ('\\t')."));
    connect(_pattern, SIGNAL(editTextChanged(QString)), this, SLOT(patternChanged()));
    hboxLayout->addWidget(_pattern);

    _button=new QToolButton(this);
    _button->setText(tr("Select"));
    _button->setEnabled(false);
    connect(_button, SIGNAL(clicked()), this, SLOT(select()));
    hboxLayout->addWidget(_button);

    _view=0;
  }

  /*!
    Description of destructor still missing
  */
  RegExpRowSelector::~RegExpRowSelector()
  {
    TRACE;
  }

  void RegExpRowSelector::setView(QAbstractItemView * view)
  {
    TRACE;
    ASSERT(!_view);
    _view=view;

    _pattern->addItems(Settings::getHistory(_view->objectName()));
  }

  void RegExpRowSelector::patternChanged()
  {
    TRACE;
    _button->setEnabled(!_pattern->currentText().isEmpty());
  }

  /*!
    Starts browsing the model and selects matching rows.
  */
  void RegExpRowSelector::select()
  {
    TRACE;
    // Stores history
    Settings::setHistory(_view->objectName(), _pattern->currentText());
    _pattern->clear();
    _pattern->addItems(Settings::getHistory(_view->objectName()));

    QRegularExpression exp(_pattern->currentText());
    QItemSelectionModel * selModel=_view->selectionModel();
    selModel->clearSelection();
    select(_view->rootIndex(), exp);
  }

  /*!
    Browses the model and selects matching rows.
  */
  void RegExpRowSelector::select(const QModelIndex& parent, QRegularExpression& exp)
  {
    TRACE;
    QItemSelectionModel * selModel=_view->selectionModel();
    QAbstractItemModel * model=_view->model();
    int nRows=model->rowCount(parent);
    int nColumns=model->columnCount(parent);
    for(int ir=0; ir<nRows; ir++) {
      // Build a string with tab separators
      QString row;
      for(int ic=0; ic<nColumns; ic++) {
        row+="\t";
        row+=model->data(model->index(ir, ic, parent), Qt::DisplayRole).toString();
      }
      row+="\t";
      if(row.indexOf(exp)>-1) {
        selModel->select(model->index(ir, 0, parent), QItemSelectionModel::Rows | QItemSelectionModel::Select);
      }
      // Tree browsing
      for(int ic=0; ic<nColumns; ic++) {
        select(model->index(ir, ic, parent), exp);
      }
    }
  }

} // namespace QGpGuiTools
