/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-04-01
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PROPERTYVALUE_H
#define PROPERTYVALUE_H

#include <QtGui>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT PropertyValue : public QObject
{
  Q_OBJECT
public:
  enum WidgetType {Unknown, Button, LineEdit, ComboBox, SpinBox, Slider, TextEdit,
                   GroupBox, DoubleSpinBox, ColorButton, Custom0, Custom1,
                   Custom2, Custom3, Custom4, Custom5, Custom6, Custom7, Custom8,
                   Custom9};

  PropertyValue(int id, QWidget * w, QWidget * label, WidgetType widgetType);

  QWidget * widget() const {return _widget;}
  QWidget * label() const {return _label;}
  WidgetType widgetType() const {return _widgetType;}
  int id() const {return _id;}

  void setValue(QVariant val);
  void reset();

  void freeze(bool f) {_frozen=f;}
  bool isFrozen() const {return _frozen;}

  QVariant value() const {return _value;}
  bool constant() const {return _constant;}

  bool isTouched() const {return _touched;}
  void setTouched(bool t=true) {_touched=t;}
public slots:
  inline void touched();
signals:
  void constantChanged(bool c);
  void touched(PropertyValue * p);
private:
  int _id;
  QWidget * _widget;
  QWidget * _label;
  WidgetType _widgetType;
  uint _constant:1;
  uint _frozen:1;
  uint _touched:1;
  QVariant _value;
};

inline void PropertyValue::touched()
{
  if(!_frozen) {
    _touched=true;
    emit touched(this);
    reset();
  }
}

} // namespace QGpGuiTools

#endif // PROPERTYVALUE_H
