/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-04-02
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "PropertyCategorySettings.h"
#include "PropertyTabSettings.h"
#include "ExpandTabWidget.h"
#include "ExpandTabTitle.h"

namespace QGpGuiTools {

/*!
  \class PropertyCategorySettings PropertyCategorySettings.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
PropertyCategorySettings::PropertyCategorySettings()
{
  _clickTime=0;
}

/*!
  Description of destructor still missing
*/
PropertyCategorySettings::~PropertyCategorySettings()
{
}

void PropertyCategorySettings::setState(uint key, const QByteArray& s)
{
  QMap<uint, PropertyTabSettings>::iterator it=_tabSettings.find(key);
  if(it!=_tabSettings.end()) {
    it.value().setState(s);
  } else {
    PropertyTabSettings settings;
    settings.setState(s);
    _tabSettings.insert(key, settings);
  }
}

void PropertyCategorySettings::setScrollPosition(uint key, int p)
{
  QMap<uint, PropertyTabSettings>::iterator it=_tabSettings.find(key);
  if(it!=_tabSettings.end()) {
    it.value().setScrollPosition(p);
  } else {
    PropertyTabSettings settings;
    settings.setScrollPosition(p);
    _tabSettings.insert(key, settings);
  }
}

QByteArray PropertyCategorySettings::state(uint key)
{
  QMap<uint, PropertyTabSettings>::iterator it=_tabSettings.find(key);
  if(it!=_tabSettings.end()) {
    return it.value().state();
  } else {
    // Initialize a byte array for an empty state
    QByteArray st;
    QDataStream s(&st, QIODevice::WriteOnly);
    int n=0;
    s << n;
    return st;
  }
}

int PropertyCategorySettings::scrollPosition(uint key)
{
  QMap<uint, PropertyTabSettings>::iterator it=_tabSettings.find(key);
  if(it!=_tabSettings.end()) {
    return it.value().scrollPosition();
  } else return 0;
}

QStringList PropertyCategorySettings::keys() const
{
  QStringList l;
  QMap<uint, PropertyTabSettings>::const_iterator it;
  for(it=_tabSettings.begin();it!=_tabSettings.end();it++) {
    l.append(QString::number(it.key()));
  }
  return l;
}

QStringList PropertyCategorySettings::scrollPositions() const
{
  QStringList l;
  QMap<uint, PropertyTabSettings>::const_iterator it;
  for(it=_tabSettings.begin();it!=_tabSettings.end();it++) {
    l.append(QString::number(it.value().scrollPosition()));
  }
  return l;
}

QList<QVariant> PropertyCategorySettings::states() const
{
  QList<QVariant> l;
  QMap<uint, PropertyTabSettings>::const_iterator it;
  for(it=_tabSettings.begin();it!=_tabSettings.end();it++) {
    l.append(it.value().state());
  }
  return l;
}

void PropertyCategorySettings::set(const QStringList& keys,
                                       const QList<QVariant>& states,
                                       const QStringList& scrollPositions)
{
  int n=keys.count();
  ASSERT(n==scrollPositions.count() && n==states.count());
  _tabSettings.clear();
  for(int i=0; i<n; i++) {
    PropertyTabSettings settings;
    settings.setState(states.at(i).toByteArray());
    settings.setScrollPosition(scrollPositions.at(i).toInt());
    _tabSettings.insert(keys.at(i).toInt(), settings);
  }
}

} // namespace QGpGuiTools
