/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-01-11
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DIALOG_H
#define DIALOG_H

#include "QGpGuiToolsDLLExport.h"
#include "WidgetRect.h"
#include "Settings.h"

namespace QGpGuiTools {

  class QGPGUITOOLS_EXPORT Dialog : public QDialog, public WidgetRect
  {
    Q_OBJECT
  public:
    Dialog(QWidget * parent=nullptr, Qt::WindowFlags f=Qt::Widget);

    void setRect(QString name) const {WidgetRect::saveRect(this, name);}
    void getRect(QString name) {Settings::getRect(this, name);}

    enum Buttons {None, OkCancel, Close, TitleClose};

    void addWidget(QWidget * w);
    void addButtons(Buttons b=OkCancel);
    void setMainWidget(QWidget * w, Buttons b=OkCancel);
  signals:
    void windowTitleChangedQt4(const QString& t);
  protected:
    virtual void resizeEvent(QResizeEvent * e);
    virtual void moveEvent(QMoveEvent * e);
    virtual void closeEvent(QCloseEvent * e);
  private:
    QVBoxLayout * _vboxLayout;
    Buttons _buttons;
  };

  class QGPGUITOOLS_EXPORT FileDialog: public QFileDialog, public WidgetRect
  {
    Q_OBJECT
  public:
    FileDialog(QWidget * parent, Qt::WindowFlags flags)
     : QFileDialog(parent, flags) {}
    FileDialog(QWidget * parent=0, const QString & caption=QString(), const QString & directory=QString(), const QString & filter=QString())
      : QFileDialog(parent, caption, directory, filter) {}

    void setRect(QString name) {WidgetRect::saveRect(this, name);}
    void getRect(QString name) {Settings::getRect(this, name);}
  protected:
    virtual void resizeEvent(QResizeEvent * e);
    virtual void moveEvent(QMoveEvent * e);
  };

} // namespace QGpGuiTools

#endif // DIALOG_H
