/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-12
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COLUMNTEXTCOLUMNSPROPERTIES_H
#define COLUMNTEXTCOLUMNSPROPERTIES_H

#include "Dialog.h"
#include "ui_ColumnTextColumnsProperties.h"
#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT ColumnTextColumnsProperties : public Dialog, public Ui::ColumnTextColumnsProperties
{
  Q_OBJECT
public:
  ColumnTextColumnsProperties(QWidget * parent=nullptr);
  ~ColumnTextColumnsProperties();

  void updateWidgets();

  QString delimiters() const;
private slots:
  void on_delimitersOption_toggled();
  void on_fixedWidthsOption_toggled();
};

} // namespace QGpGuiTools

#endif // COLUMNTEXTCOLUMNSPROPERTIES_H
