/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-01-05
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef BUGREPORT_H
#define BUGREPORT_H

#include "ui_BugReport.h"
#include "HttpAccess.h"
#include "Dialog.h"

class QHttp;

namespace QGpGuiTools {

class HttpAccess;

class QGPGUITOOLS_EXPORT BugReport : public Dialog, private Ui::BugReport
{
  Q_OBJECT
public:
  BugReport(QWidget* parent=0, Qt::WindowFlags fl=Qt::WindowFlags());
  ~BugReport();

  void setInfo(const QString & bugInfo);
private slots:
  void on_sendBut_clicked();
  void on_saveBut_clicked();
  void on_attach_clicked();
  void sent(bool ok);
private:
  void setGuiEnable(bool e);
  void send();
  QByteArray bugInfo();

  QStringList _attachments;
  HttpAccess * _access;
};

} // namespace QGpGuiTools

#endif // BUGREPORT_H
