/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  QGpGuiMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-25
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ImageScalingPointDelegate.h"

namespace QGpGuiMath {

  /*!
    \class ImageScalingPointDelegate ImageScalingPointDelegate.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  QWidget * ImageScalingPointDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem &,
                                                    const QModelIndex & index) const
  {
    TRACE;
    switch (index.column()) {
    case 0:
      return createLineEdit(parent);
    case 1:
    case 2: {
        QSpinBox * w=createSpinBox(parent);
        w->setSuffix( " px" );
        w->setMinimum(0);
        w->setMaximum(INT_MAX);
      return w;
      }
    default: {
        DoubleSpinBox * w=createDoubleSpinBox(parent);
        w->setMinimum(-std::numeric_limits<double>::infinity());
        w->setMaximum(std::numeric_limits<double>::infinity());
        w->setDecimals(3);
        return w;
      }
    }
  }

} // namespace QGpGuiMath

