/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-08
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef IMAGESCALINGPOINT_H
#define IMAGESCALINGPOINT_H

#include <SciFigs.h>

#include "ImageLayer.h"
#include "QGpGuiMathDLLExport.h"

namespace Ui {
  class ImageScalingPoint;
}

namespace QGpGuiMath {

  class ImageScalingPointModel;

  class QGPGUIMATH_EXPORT ImageScalingPoint : public Dialog
  {
    Q_OBJECT
  public:
    ImageScalingPoint(QWidget * parent=nullptr);
    ~ImageScalingPoint();

    void setLayer(ImageLayer * layer);
    const QList<ImageLayer::ReferencePoint>& references() const {return _references;}
  public slots:
    void add(const Point2D& p);
  private slots:
    void on_add_clicked();
    void on_remove_clicked();
    void on_importCoordinates_clicked();
    void on_exportCoordinates_clicked();
    void setScaling();
    void endPick();
  private:
    ImageScalingPointModel * model() const;

    Ui::ImageScalingPoint * _ui;
    UtmZone _utmZone;
    QList<ImageLayer::ReferencePoint> _references;
    LayerPicker * _picker;
    ImageLayer * _layer;
  };

} // namespace QGpGuiMath

#endif // IMAGESCALINGPOINT_H
