/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-11-02
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "CurveBrowserCut.h"

namespace QGpGuiMath {

  /*!
    \class CurveBrowserCut CurveBrowserCut.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  CurveBrowserCut::CurveBrowserCut(QWidget * parent)
      : Dialog(parent)
  {
    TRACE;
    setupUi(this);
  }

  void CurveBrowserCut::setAxisNames(QString linearName, QString inverseName)
  {
    TRACE;
    linearBut->setText(linearName);
    inverseBut->setText(inverseName);
  }

  void CurveBrowserCut::on_inverseBut_toggled(bool)
  {
    TRACE;
    double min=minimumEdit->text().toDouble();
    double max=maximumEdit->text().toDouble();
    minimumEdit->setText(QString::number(1.0/max));
    maximumEdit->setText(QString::number(1.0/min));
  }

  void CurveBrowserCut::on_autoMin_clicked()
  {
    TRACE;
    minimumEdit->setText(QString::number(_curveMin));
  }

  void CurveBrowserCut::on_autoMax_clicked()
  {
    TRACE;
    maximumEdit->setText(QString::number(_curveMax));
  }

} // namespace QGpGuiMath
