/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-08-06
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TILTNODE_H
#define TILTNODE_H

#include "RefractionDippingModel.h"
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

class TiltPath;

class QGPCOREWAVE_EXPORT TiltNode
{
public:
  TiltNode();
  ~TiltNode();

  void init(double x0, const RefractionDippingModel& model);
  double x() const;
  const TiltPath * left() const {return _leftPaths;}
  const TiltPath * right() const {return _rightPaths;}
private:
  void initPaths(RefractionDippingModel::Direction dir, TiltPath *& paths,
                  double x0, const RefractionDippingModel& model);

  TiltPath * _leftPaths;
  TiltPath * _rightPaths;
};

} // namespace QGpCoreWave

#endif // TILTNODE_H
