/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-11-12
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef THEORETICALFK_H
#define THEORETICALFK_H

#include <QGpCoreMath.h>

#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

  class QGPCOREWAVE_EXPORT TheoreticalFK : public AbstractFunction
  {
  public:
    TheoreticalFK(const VectorList<Point2D>& stations);

    double value(Vector<double>& k) const;
    const VectorList<Point2D>& stations() const {return _stations;}

    double radialFirstDerivative(const Vector<double>& k) const;
    double radialSecondDerivative(const Vector<double>& k) const;
    double radialSecondDerivativeAtOrigin(const Vector<double>& k) const;

    double shapeFactor() const;
    void distanceRange(double& min, double& max) const;
  private:
    VectorList<Point2D> _stations;
    double _fac;
  };

} // namespace QGpCoreWave

#endif // THEORETICALFK_H
