/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-11-03
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DISPERSIONPROXY_H
#define DISPERSIONPROXY_H

#include <QGpCoreTools.h>

#include "ModalProxy.h"
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

class QGPCOREWAVE_EXPORT DispersionProxy : public ModalProxy
{
  TRANSLATIONS("DispersionProxy")
public:
  QString tag() const {return "DispersionProxy";}

  CurveProxy * clone() const {return new DispersionProxy;}

  int columnCount() const {return 7;}
  QString columnName(int col) const;
  QString columnUnit(int col) const;

  QVariant columnValue(int sample, int col) const;
  void setColumnValue(int sample, int col, const QVariant & value);

  int xAxisColumn() const {return 0;}
  int xAxisInverseColumn() const  {return 1;}
  int yAxisColumn() const {return 2;}
  int yAxisInverseColumn() const {return 3;}

  QStringList columnFileTypes() const;
  VectorList<int> defaultColumnFileTypes() const;
  VectorList<int> savedColumns() const;

  bool parse(ColumnTextIterator& it);
};

} // namespace QGpCoreWave

#endif // DISPERSIONPROXY_H
