/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-09-26
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DISPERSIONFACTORY_H
#define DISPERSIONFACTORY_H

#include "ModalFactory.h"
#include "Dispersion.h"
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

  class EllipticityFactory;
  class AutocorrFactory;
  class ModalCurve;

  class QGPCOREWAVE_EXPORT DispersionFactory : public ModalFactory
  {
  public:
    DispersionFactory();
    ~DispersionFactory();

    Dispersion * phaseRayleigh() const {return _phaseRayleigh;}
    Dispersion * groupRayleigh() const {return _groupRayleigh;}
    Dispersion * phaseLove() const {return _phaseLove;}
    Dispersion * groupLove() const {return _groupLove;}

    void validate(EllipticityFactory * ellFactory, AutocorrFactory * autocorr);
    bool calculate(const Seismic1DModel * model, EllipticityFactory * ellFactory);
    void setPhaseRayleigh(const ModalCurve& c);

    virtual void setMode(const Mode& m);
    virtual const RealValue * mode(const Mode& m) const;
    virtual int storageCount() const {return 4;}
    inline virtual ModalStorage * storage(int storageIndex) const;
  protected:
    virtual ModalStorage * newStorage(int nModes) {return new Dispersion(nModes, x());}
  private:
    Dispersion * _phaseRayleigh;
    Dispersion * _groupRayleigh;
    Dispersion * _phaseLove;
    Dispersion * _groupLove;
  };

  inline ModalStorage *  DispersionFactory::storage(int storageIndex) const
  {
    TRACE;
    switch (storageIndex) {
    case 1:
      return _groupRayleigh;
    case 2:
      return _phaseLove;
    case 3:
      return _groupLove;
    default:
      return _phaseRayleigh;
    }
  }

} // namespace QGpCoreWave

#endif // DISPERSIONFACTORY_H
