/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  QGpCoreTools is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreTools is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-20
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef STRINGDIFF_H
#define STRINGDIFF_H

#include <QtCore>

#include "QGpCoreToolsDLLExport.h"
#include "Global.h"

namespace QGpCoreTools {

  class QGPCORETOOLS_EXPORT StringDiff
  {
  public:
    bool operator<(const StringDiff&) const {return false;}
    bool operator==(const StringDiff&) const {return true;}

    void setDifferences(const QString& s1, const QString& s2);
    bool isValid() const {return !_actions.isEmpty();}
    QString patch(const QString& s) const;

    QString toString() const;
    static bool test(const QString& refIn, const QString& refOut,
                     const QString& in, const QString& out);
    static void test();
  private:
    inline bool atEnd(const QString& s1, const QString& s2, int i1, int i2);

    class Action
    {
    public:
      enum Type {Remove, Insert};

      Action();
      Action(const QString& s, int startIndex, int count=0, const QString& insert=QString());

      void setContextStartIndex(int startIndex);

      const QString& beforeText() const {return _beforeText;}
      const QString& afterText() const {return _afterText;}
      const QString& insertText() const {return _insertText;}
      int startIndex() const {return _startIndex;}
      int endIndex() const {return _endIndex;}

      QString toString() const;
    private:
      inline QString beforeContext(const QString& s, int startIndex);
      inline QString afterContext(const QString& s, int endIndex);
      //inline QString context(const QString& s, int startIndex, int endIndex);

      QString _beforeText, _afterText, _insertText;
      int _startIndex, _endIndex;
    };

    void add(Action a);

    VectorList<Action> _actions;
  };

} // namespace QGpCoreTools

#endif // STRINGDIFF_H

