/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  QGpCoreTools is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreTools is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-18
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ParallelTaskWorker.h"
#include "ParallelTaskManager.h"
#include "ParallelTask.h"

namespace QGpCoreTools {

  /*!
    \class ParallelTaskWorker ParallelTaskWorker.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ParallelTaskWorker::ParallelTaskWorker()
    : LoopWorker()
  {
    TRACE;
    _taskManager=nullptr;
  }

  /*!
    Description of destructor still missing
  */
  ParallelTaskWorker::~ParallelTaskWorker()
  {
    TRACE;
  }

  void ParallelTaskWorker::run(int)
  {
    ASSERT(_taskManager);
    ParallelTask * t;
    while(!terminated()) {
      t=_taskManager->nextFreshTask();
      if(!t) {
        break;
      }
      process(t);
    }
    _taskManager->purgeTasks();
    while(!terminated()) {
      t=_taskManager->nextTask();
      if(!t) {
        break;
      }
      process(t);
    }
    _taskManager->purgeTasks();
    while(!terminated()) {
      t=_taskManager->nextTaskToPolish();
      if(!t) {
        break;
      }
      polish(t);
      t->deleteLater(); // Deleting directly here had instable consequences
                        // There was sometimes a deleted task that was not removed
                        // from parent list.
    }
    mergeResults();  // End of this worker
  }

} // namespace QGpCoreTools

