/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  QGpCoreTools is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreTools is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-09-12
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ENUMASSTRING_H
#define ENUMASSTRING_H

#include "QGpCoreToolsDLLExport.h"
#include "Global.h"

namespace QGpCoreTools {

  class QGPCORETOOLS_EXPORT EnumAsString
  {
  public:
    EnumAsString(const char * name, const char** keys, const int * values);

    void addSynonym(const char * key, int value);
    void setDefaultValue(int value) {_defaultValue=value;}

    int value(const StringView& key, bool& ok) const;
    const char * key(int value) const;

    void assertValidity();

    static EnumAsString * allocate(const char * name, const char** keys, const int * values);
    static void deleteAllEnums();
  private:
    const char * _name;
    int _defaultValue;
    int _size, _size2;
    const char ** _keys;
    const int * _values;
    const char ** _hash;
#if(QT_VERSION>=QT_VERSION_CHECK(6, 0, 0))
    QMap<QLatin1StringView, int> _synonyms;
#else
    QMap<QLatin1String, int> _synonyms;
#endif

    static QList<EnumAsString *> _allEnums;
  };

} // namespace QGpCoreTools

#define ENUM_AS_STRING_DECL(Name) \
private: \
    static EnumAsString * _enum##Name; \
    public: \
    static void initEnum##Name(); \
    static const char * convert##Name(Name value) { \
        return _enum##Name->key(static_cast<int>(value)); \
    } \
    static Name convert##Name(const StringView& key, bool& ok) { \
        return static_cast<Name>(_enum##Name->value(key, ok)); \
    }

#define ENUM_AS_STRING_DECL_NAMESPACE(NameSpace, Name) \
  private: \
    static EnumAsString * _enum##Name; \
  public: \
    static void initEnum##Name(); \
    static const char * convert##Name(NameSpace::Name value) { \
      return _enum##Name->key(static_cast<int>(value)); \
    } \
    static NameSpace::Name convert##Name(const StringView& key, bool& ok) { \
     return static_cast<NameSpace::Name>(_enum##Name->value(key, ok)); \
    }

#define ENUM_AS_STRING_BEGIN(Class, Name) \
  EnumAsString * Class::_enum##Name=nullptr; \
  class Class##Name##EnumRegister \
  { \
  public: \
    Class##Name##EnumRegister() { \
      Class::initEnum##Name(); \
    } \
  }; \
  static Class##Name##EnumRegister enumRegister##Class##Name; \
  void Class::initEnum##Name() \
  { \
    const char * name=#Name; \
    EnumAsString *& e=_enum##Name; \
    ASSERT(!e);

#define ENUM_AS_STRING_END \
    e->assertValidity(); \
  }

#define ENUM_AS_STRING_DEFAULT_VALUE(value) \
    e->setDefaultValue(value)
#define ENUM_AS_STRING_SYNONYM(key, value) \
    e->addSynonym(key, value)

#define ENUM_AS_STRING_DATA_2(v1, v2) \
    static const char* keys[]={#v1, #v2, nullptr}; \
    static const int values[]={v1, v2}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_3(v1, v2, v3) \
    static const char* keys[]={#v1, #v2, #v3, nullptr}; \
    static const int values[]={v1, v2, v3}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_4(v1, v2, v3, v4) \
    static const char* keys[]={#v1, #v2, #v3, #v4, nullptr}; \
    static const int values[]={v1, v2, v3, v4}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_5(v1, v2, v3, v4, v5) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_6(v1, v2, v3, v4, v5, v6) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_7(v1, v2, v3, v4, v5, v6, v7) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_8(v1, v2, v3, v4, v5, v6, v7, v8) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, #v8, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7, v8}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_9(v1, v2, v3, v4, v5, v6, v7, v8, v9) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, #v8, #v9, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7, v8, v9}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_10(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, #v8, #v9, #v10, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7, v8, v9, v10}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_11(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, #v8, #v9, #v10, \
                               #v11, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_12(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, #v8, #v9, #v10, \
                               #v11, #v12, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_13(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, #v8, #v9, #v10, \
                               #v11, #v12, #v13, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_14(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, #v8, #v9, #v10, \
                               #v11, #v12, #v13, #v14, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_15(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, #v8, #v9, #v10, \
                               #v11, #v12, #v13, #v14, #v15, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_16(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15, v16) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, #v8, #v9, #v10, \
                               #v11, #v12, #v13, #v14, #v15, #v16, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15, v16}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_17(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15, v16, v17) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, #v8, #v9, #v10, \
                               #v11, #v12, #v13, #v14, #v15, #v16, #v17, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15, v16, v17}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_18(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15, v16, v17, v18) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, #v8, #v9, #v10, \
                               #v11, #v12, #v13, #v14, #v15, #v16, #v17, #v18, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15, v16, v17, v18}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_19(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15, v16, v17, v18, v19) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, #v8, #v9, #v10, \
                               #v11, #v12, #v13, #v14, #v15, #v16, #v17, #v18, #v19, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15, v16, v17, v18, v19}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_20(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15, v16, v17, v18, v19, v20) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, #v8, #v9, #v10, \
                               #v11, #v12, #v13, #v14, #v15, #v16, #v17, #v18, #v19, #v20, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15, v16, v17, v18, v19, v20}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_21(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15, v16, v17, v18, v19, v20, \
                               v21) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, #v8, #v9, #v10, \
                               #v11, #v12, #v13, #v14, #v15, #v16, #v17, #v18, #v19, #v20, \
                               #v21, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15, v16, v17, v18, v19, v20, \
                               v21}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_22(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15, v16, v17, v18, v19, v20, \
                               v21, v22) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, #v8, #v9, #v10, \
                               #v11, #v12, #v13, #v14, #v15, #v16, #v17, #v18, #v19, #v20, \
                               #v21, #v22, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15, v16, v17, v18, v19, v20, \
                               v21, v22}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_23(v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15, v16, v17, v18, v19, v20, \
                               v21, v22, v23) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, #v7, #v8, #v9, #v10, \
                               #v11, #v12, #v13, #v14, #v15, #v16, #v17, #v18, #v19, #v20, \
                               #v21, #v22, #v23, nullptr}; \
    static const int values[]={v1, v2, v3, v4, v5, v6, v7, v8, v9, v10, \
                               v11, v12, v13, v14, v15, v16, v17, v18, v19, v20, \
                               v21, v22, v23}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_NAMESPACE_2(NameSpace, v1, v2) \
    static const char* keys[]={#v1, #v2, nullptr}; \
    static const int values[]={NameSpace::v1, NameSpace::v2}; \
    e=EnumAsString::allocate(name, keys, values)

#define ENUM_AS_STRING_DATA_NAMESPACE_6(NameSpace, v1, v2, v3, v4, v5, v6) \
    static const char* keys[]={#v1, #v2, #v3, #v4, #v5, #v6, nullptr}; \
    static const int values[]={NameSpace::v1, NameSpace::v2, NameSpace::v3, NameSpace::v4, \
                               NameSpace::v5, NameSpace::v6}; \
    e=EnumAsString::allocate(name, keys, values)

#endif // ENUMASSTRING_H

