/***************************************************************************
**
**  This file is part of QGpCoreStat.
**
**  QGpCoreStat is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreStat is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-01-24
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "SampleClassificationParameters.h"

namespace QGpCoreStat {

  /*!
    \class SampleClassificationParameters SampleClassificationParameters.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  SampleClassificationParameters::SampleClassificationParameters()
    : AbstractParameters()
  {
    _valueConditionType=AbsoluteThreshold;
    _categoryConditionType=AllCategories;
    _categoryCondition=0;
    _action=Invalidate;
    _threshold=2;
    _absoluteRange=1.0;
    _relativeRange=10.0;
    _stddevRange=2.0;
    _category=-1;
  }

  SampleClassificationParameters::SampleClassificationParameters(const SampleClassificationParameters& o)
    : AbstractParameters(o)
  {
    _valueConditionType=o._valueConditionType;
    _categoryConditionType=o._categoryConditionType;
    _categoryCondition=o._categoryCondition;
    _action=o._action;
    _threshold=o._threshold;
    _absoluteRange=o._absoluteRange;
    _relativeRange=o._relativeRange;
    _stddevRange=o._stddevRange;
    _curve1=o._curve1;
    _curve2=o._curve2;
    _category=o._category;
    _fileParser=o._fileParser;
    _file=o._file;
  }

  AbstractParameters * SampleClassificationParameters::clone() const
  {
    return new SampleClassificationParameters(*this);
  }

  int SampleClassificationParameters::keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const
  {
    return 12+AbstractParameters::keywordCount();
  }

  void SampleClassificationParameters::collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS)
  {
    TRACE;
    int baseIndex=AbstractParameters::keywordCount();
    keywords.add(prefix+"VALUE_CONDITION_TYPE", this, baseIndex);
    keywords.add(prefix+"CATEGORY_CONDITION_TYPE", this, baseIndex+10);
    keywords.add(prefix+"CATEGORY_CONDITION", this, baseIndex+11);
    keywords.add(prefix+"ACTION", this, baseIndex+1);
    keywords.add(prefix+"THRESHOLD", this, baseIndex+2);
    keywords.add(prefix+"ABSOLUTE_RANGE", this, baseIndex+3);
    keywords.add(prefix+"RELATIVE_RANGE", this, baseIndex+4);
    keywords.add(prefix+"STDDEV_RANGE", this, baseIndex+5);
    keywords.add(prefix+"CURVE_1", this, baseIndex+6);
    keywords.add(prefix+"CURVE_2"+suffix, this, baseIndex+7);
    keywords.add(prefix+"FILE_PARSER"+suffix, this, baseIndex+8);
    keywords.add(prefix+"FILE"+suffix, this, baseIndex+9);
  }

  QString SampleClassificationParameters::toString(PARAMETERS_TOSTRING_ARGS_IMPL) const
  {
    TRACE;
    QString log;
    log+="# Value condition:\n"
         "#    None\n"
         "#    AbsoluteThreshold\n"
         "#    RelativeThreshold\n"
         "#    CurveAbsoluteInsideRange\n"
         "#    CurveRelativeInsideRange\n"
         "#    CurveStddevInsideRange\n"
         "#    CurveAbsoluteOutsideRange\n"
         "#    CurveRelativeOutsideRange\n"
         "#    CurveStddevOutsideRange\n"
         "#    AboveCurve\n"
         "#    BelowCurve\n"
         "#    InsideCurves\n"
         "#    OutsideCurves\n";
    log+=prefix+"VALUE_CONDITION_TYPE"+suffix+"="+convertValueCondition(_valueConditionType)+"\n";
    log+="# Category condition:\n"
         "#    AnyCategory\n"
         "#    InsideCategory\n"
         "#    OutsideCategory\n";
    log+=prefix+"CATEGORY_CONDITION_TYPE"+suffix+"="+convertCategoryCondition(_categoryConditionType)+"\n";
    log+="# Action of filter:\n"
         "#    Reset\n"
         "#    Invalidate\n"
         "#    Validate\n"
         "#    Categorize\n"
         "#    ResetCategory\n";
    log+=prefix+"ACTION"+suffix+"="+convertAction(_action)+"\n";
    log+="# If TYPE==AbsoluteThreshold or RelativeThreshold, filters out all samples in classes which value is less than\n"
         "# THRESHOLD.\n";
    log+=prefix+"THRESHOLD"+suffix+"="+QString::number(_threshold)+"\n";
    log+="# If TYPE==CurveAbsolute..Range, filters out all samples inside/outside a range defined by an\n"
         "# absolute value around CURVE_1.\n";
    log+=prefix+"ABSOLUTE_RANGE"+suffix+"="+QString::number(_absoluteRange)+"\n";
    log+="# If TYPE==CurveRelative...Range, filters out all samples inside/outside a range defined by a\n"
         "# relative value around CURVE_1.\n";
    log+=prefix+"RELATIVE_RANGE"+suffix+" (%)="+QString::number(_relativeRange*100.0)+"\n";
    log+="# If TYPE==CurveStddev...Range, filters out all samples inside/outside a range defined by a\n"
         "# factor to the standard deviation of CURVE_1.\n";
    log+=prefix+"STDDEV_RANGE"+suffix+"="+QString::number(_stddevRange)+"\n";
    log+="# Name of first curve.\n";
    log+=prefix+"CURVE_1"+suffix+"="+_curve1+"\n";
    log+="# Name of second curve.\n";
    log+=prefix+"CURVE_2"+suffix+"="+_curve2+"\n";
    log+="# File parser to load FILE.\n";
    log+=prefix+"FILE_PARSER"+suffix+"="+_fileParser+"\n";
    log+="# File name containing curves.\n";
    log+=prefix+"FILE"+suffix+"="+_file+"\n";
    return log;
  }

  bool SampleClassificationParameters::setValue(PARAMETERS_SETVALUE_ARGS)
  {
    TRACE;
    bool ok=true;
    switch(index-AbstractParameters::keywordCount()) {
    case 0:
      _valueConditionType=convertValueCondition(value, ok);
      return ok;
    case 1:
      _action=convertAction(value, ok);
      return ok;
    case 2:
      _threshold=value.toDouble(&ok);
      return ok;
    case 3:
      _absoluteRange=value.toDouble(&ok);
      return ok;
    case 4:
      _relativeRange=value.toDouble(&ok)*0.01;
      return ok;
    case 5:
      _stddevRange=value.toDouble(&ok);
      return ok;
    case 6:
      _curve1=value;
      return true;
    case 7:
      _curve2=value;
      return true;
    case 8:
      _fileParser=value;
      return true;
    case 9:
      _file=value;
      return true;
    default:
      break;
    }
    return AbstractParameters::setValue(index, value, unit, keywords);
  }

  ENUM_AS_STRING_BEGIN(SampleClassificationParameters, Action)
  ENUM_AS_STRING_DATA_4(Categorize, Invalidate, Reset, Validate);
  ENUM_AS_STRING_END

  ENUM_AS_STRING_BEGIN(SampleClassificationParameters, ValueCondition)
  ENUM_AS_STRING_DATA_13(AboveCurve, AbsoluteThreshold, BelowCurve, CurveAbsoluteInsideRange,
                         CurveAbsoluteOutsideRange, CurveRelativeInsideRange, CurveRelativeOutsideRange,
                         CurveStddevInsideRange, CurveStddevOutsideRange, InsideCurves, NoCondition,
                         OutsideCurves, RelativeThreshold);
  ENUM_AS_STRING_END

  ENUM_AS_STRING_BEGIN(SampleClassificationParameters, CategoryCondition)
  ENUM_AS_STRING_DATA_3(AllCategories, AllExceptOneCategory, OneCategory);
  ENUM_AS_STRING_END

} // namespace QGpCoreStat

