/***************************************************************************
**
**  This file is part of QGpCoreStat.
**
**  QGpCoreStat is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreStat is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-08-24
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "GaussianMixtureParameters.h"

namespace QGpCoreStat {

  /*!
    \class GaussianMixtureParameters GaussianMixtureParameters.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  GaussianMixtureParameters::GaussianMixtureParameters()
    : AbstractParameters()
  {
    TRACE;
    _modeCount=2;
    _meanSpacingFactor=1.05;
    _verbose=false;
    _kmin=0.0;
    _kmax=0.0;
  }

  GaussianMixtureParameters::~GaussianMixtureParameters()
  {
    TRACE;
  }

  AbstractParameters * GaussianMixtureParameters::clone() const
  {
    TRACE;
    return new GaussianMixtureParameters(*this);
  }

  int GaussianMixtureParameters::maximumModeCount(double min, double max) const
  {
    TRACE;
    min=fabs(min);
    max=fabs(max);
    if(min>max) {
      qSwap(min, max);
    }
    return floor(log(max/min)/log(_meanSpacingFactor));
  }

} // namespace QGpCoreStat

