/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-21
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "StatisticalValue.h"

namespace QGpCoreMath {

  /*!
    \class StatisticalValue StatisticalValue.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  const QString RealStatisticalValue::xmlRealStatisticalValueTag="RealStatisticalValue";
  const QString ComplexStatisticalValue::xmlComplexStatisticalValueTag="ComplexStatisticalValue";

  /*!
    \fn double StatisticalValue::misfit(int& nValues, int& nData, const Value& val, Misfit::Type type, double min) const

    Returns a misfit value comparing \a val with the mean and stddev.

    \a nValues is incremented by one if the value and this point are valid.
    \a nData is incremented by one if this point is valid.

    If \a min is greater than 0, the difference between \a val and mean (eventually normalized) is clipped to \a min.
  */

} // namespace QGpCoreMath
